/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleDialog;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.util.Util;

public class NoppesUtilPlayer {
    public static final Map<Object, Long> delaySendMap = new HashMap<Object, Long>();

    public static void bankClearCeil(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!player.field_71075_bZ.field_75098_d || !(player.field_71070_bA instanceof ContainerNPCBank)) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        if (!bd.cells.containsKey(ceilId)) {
            return;
        }
        ((ContainerNPCBank)player.field_71070_bA).items.func_174888_l();
        player.field_71070_bA.func_75142_b();
        bd.save();
        NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
    }

    public static void bankLock(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!player.field_71075_bZ.field_75098_d || !(player.field_71070_bA instanceof ContainerNPCBank)) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        if (!bd.bank.ceilSettings.containsKey(ceilId) || bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).openStack.func_190926_b()) {
            return;
        }
        bd.cells.put(ceilId, new NpcMiscInventory(0));
        bd.save();
        NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
    }

    public static void bankRegrade(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!player.field_71075_bZ.field_75098_d || !(player.field_71070_bA instanceof ContainerNPCBank)) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        if (!bd.cells.containsKey(ceilId) || bd.cells.get(ceilId).func_70302_i_() < 0) {
            return;
        }
        if (bd.cells.get(ceilId).func_70302_i_() == 1) {
            NoppesUtilPlayer.bankLock(player, npc);
            return;
        }
        bd.cells.computeIfPresent(ceilId, (k, inv) -> new NpcMiscInventory(inv.func_70302_i_() - 1).fill((NpcMiscInventory)inv));
        bd.save();
        NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
    }

    public static void bankResetCeil(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!player.field_71075_bZ.field_75098_d || !(player.field_71070_bA instanceof ContainerNPCBank)) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        if (!bd.cells.containsKey(ceilId) || !bd.bank.ceilSettings.containsKey(ceilId)) {
            return;
        }
        ((ContainerNPCBank)player.field_71070_bA).items.func_174888_l();
        player.field_71070_bA.func_75142_b();
        bd.cells.put(ceilId, new NpcMiscInventory(bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).startCells));
        bd.save();
        NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
    }

    public static void bankUnlock(EntityPlayerMP player, EntityNPCInterface npc, boolean isStack) {
        boolean canOpen;
        if (!(player.field_71070_bA instanceof ContainerNPCBank) || npc == null) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        boolean bl = canOpen = player.field_71075_bZ.field_75098_d || bd.bank.isPublic || player.func_110124_au().equals(bd.getUUID()) || bd.bank.owner.equals(player.func_70005_c_());
        if (canOpen) {
            if (isStack) {
                canOpen = Util.instance.removeItem(player, bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).openStack, false, false);
            } else {
                PlayerData data = PlayerData.get((EntityPlayer)player);
                boolean bl2 = canOpen = (long)bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).openMoney <= data.game.getMoney();
                if (canOpen) {
                    data.game.addMoney(-bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).openMoney);
                }
            }
        }
        if (canOpen) {
            bd.cells.put(ceilId, new NpcMiscInventory(bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).startCells));
            bd.save();
            RoleEvent.BankUnlockedEvent event = new RoleEvent.BankUnlockedEvent((EntityPlayer)player, npc.wrappedNPC, ceilId);
            EventHooks.onNPCRole(npc, event);
        }
        NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
    }

    public static void bankUpgrade(EntityPlayerMP player, EntityNPCInterface npc, boolean isStack, int count) {
        boolean canUpgrade;
        if (!(player.field_71070_bA instanceof ContainerNPCBank) || npc == null) {
            return;
        }
        int ceilId = ((ContainerNPCBank)player.field_71070_bA).ceil;
        BankData bd = ((ContainerNPCBank)player.field_71070_bA).data;
        if (!bd.cells.containsKey(ceilId)) {
            return;
        }
        boolean bl = canUpgrade = player.field_71075_bZ.field_75098_d || bd.bank.isPublic || player.func_110124_au().equals(bd.getUUID()) || bd.bank.owner.equals(player.func_70005_c_());
        if (canUpgrade) {
            if (isStack) {
                canUpgrade = Util.instance.removeItem(player, bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).upgradeStack, count, false, false);
            } else {
                PlayerData data = PlayerData.get((EntityPlayer)player);
                int need = bd.bank.ceilSettings.get((Object)Integer.valueOf((int)ceilId)).upgradeMoney * count;
                boolean bl2 = canUpgrade = (long)need <= data.game.getMoney();
                if (canUpgrade) {
                    data.game.addMoney(-1 * need);
                }
            }
        }
        if (canUpgrade) {
            bd.cells.computeIfPresent(ceilId, (k, inv) -> new NpcMiscInventory(inv.func_70302_i_() + count).fill((NpcMiscInventory)inv));
            bd.save();
            RoleEvent.BankUpgradedEvent event = new RoleEvent.BankUpgradedEvent((EntityPlayer)player, npc.wrappedNPC, ceilId);
            EventHooks.onNPCRole(npc, event);
            if (((ContainerNPCBank)player.field_71070_bA).items.func_70302_i_() == 45) {
                bd.openBankGui((EntityPlayer)player, npc, ceilId);
            } else {
                NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
            }
        } else {
            NoppesUtilPlayer.openBankGui(bd, player, npc, ceilId);
        }
    }

    public static void changeFollowerState(EntityPlayerMP player, EntityNPCInterface npc) {
        if (!(npc.advanced.roleInterface instanceof RoleFollower)) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.advanced.roleInterface;
        EntityPlayer owner = role.owner;
        if (owner == null || !owner.func_70005_c_().equals(player.func_70005_c_())) {
            return;
        }
        role.isFollowing = !role.isFollowing;
    }

    public static void closeDialog(EntityPlayerMP player, EntityNPCInterface npc, boolean notifyClient) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        Dialog dialog = DialogController.instance.dialogs.get(data.dialogId);
        EventHooks.onNPCDialogClose(npc, player, dialog);
        if (notifyClient) {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, -1, new NBTTagCompound());
        }
        data.dialogId = -1;
    }

    private static boolean compareItemDetails(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        return !(item.func_77973_b() != item2.func_77973_b() || !ignoreDamage && item.func_77952_i() != -1 && item.func_77952_i() != item2.func_77952_i() || !ignoreNBT && item.func_77978_p() != null && (item2.func_77978_p() == null || !item.func_77978_p().equals((Object)item2.func_77978_p())) || !ignoreNBT && item2.func_77978_p() != null && item.func_77978_p() == null);
    }

    public static boolean compareItems(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        int size = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            size += is.func_190916_E();
        }
        return size >= item.func_190916_E();
    }

    public static boolean compareItems(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT, int amount) {
        int size = 0;
        if (player == null) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (NoppesUtilServer.IsItemStackNull(is) || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            size += is.func_190916_E();
        }
        return size >= amount;
    }

    public static boolean compareItems(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        int[] ids;
        if (NoppesUtilServer.IsItemStackNull(item) || NoppesUtilServer.IsItemStackNull(item2)) {
            return false;
        }
        OreDictionary.itemMatches((ItemStack)item, (ItemStack)item2, (boolean)false);
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)item)) {
            boolean match1 = false;
            boolean match2 = false;
            for (ItemStack is : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                if (NoppesUtilPlayer.compareItemDetails(item, is, ignoreDamage, ignoreNBT)) {
                    match1 = true;
                }
                if (!NoppesUtilPlayer.compareItemDetails(item2, is, ignoreDamage, ignoreNBT)) continue;
                match2 = true;
            }
            if (!match1 || !match2) continue;
            return true;
        }
        return NoppesUtilPlayer.compareItemDetails(item, item2, ignoreDamage, ignoreNBT);
    }

    public static void dialogSelected(int diaId, int optionId, EntityPlayerMP player, EntityNPCInterface npc) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (data.dialogId != diaId) {
            return;
        }
        if (data.dialogId < 0 && npc.advanced.roleInterface instanceof RoleDialog) {
            String text = ((RoleDialog)npc.advanced.roleInterface).optionsTexts.get(optionId);
            if (text != null && !text.isEmpty()) {
                Dialog d = new Dialog(null);
                d.text = text;
                NoppesUtilServer.openDialog((EntityPlayer)player, npc, d);
            }
            return;
        }
        Dialog dialog = DialogController.instance.dialogs.get(data.dialogId);
        if (dialog == null) {
            return;
        }
        if (!dialog.hasDialogs((EntityPlayer)player) && dialog.notHasOtherOptions()) {
            NoppesUtilPlayer.closeDialog(player, npc, true);
            return;
        }
        DialogOption option = dialog.options.get(optionId);
        if (option == null || EventHooks.onNPCDialogOption(npc, player, dialog, option) || option.optionType == OptionType.DIALOG_OPTION && (!option.isAvailable((EntityPlayer)player) || !option.hasDialogs()) || option.optionType == OptionType.DISABLED || option.optionType == OptionType.QUIT_OPTION) {
            NoppesUtilPlayer.closeDialog(player, npc, true);
            return;
        }
        if (option.optionType == OptionType.ROLE_OPTION) {
            NoppesUtilPlayer.closeDialog(player, npc, true);
            if (npc.advanced.roleInterface != null) {
                if (npc.advanced.roleInterface instanceof RoleCompanion) {
                    ((RoleCompanion)npc.advanced.roleInterface).interact((EntityPlayer)player, true);
                } else {
                    npc.advanced.roleInterface.interact((EntityPlayer)player);
                }
            }
        } else if (option.optionType == OptionType.DIALOG_OPTION) {
            NoppesUtilPlayer.closeDialog(player, npc, false);
            NoppesUtilServer.openDialog((EntityPlayer)player, npc, option.getDialog((EntityPlayer)player));
        } else if (option.optionType == OptionType.COMMAND_BLOCK) {
            NoppesUtilPlayer.closeDialog(player, npc, true);
            NoppesUtilServer.runCommand(npc, npc.func_70005_c_(), option.command, (EntityPlayer)player);
        } else {
            NoppesUtilPlayer.closeDialog(player, npc, true);
        }
    }

    public static void extendFollower(EntityPlayerMP player, EntityNPCInterface npc, int pos) {
        if (!(npc.advanced.roleInterface instanceof RoleFollower)) {
            return;
        }
        Container con = player.field_71070_bA;
        if (!(con instanceof ContainerNPCFollowerHire)) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.advanced.roleInterface;
        NoppesUtilPlayer.followerBuy(role, pos, player, npc);
    }

    private static void followerBuy(RoleFollower role, int pos, EntityPlayerMP player, EntityNPCInterface npc) {
        int days;
        RoleEvent.FollowerHireEvent event;
        if (pos < 0 || pos > 3 || !role.rates.containsKey(pos)) {
            return;
        }
        if (pos == 3) {
            if (!player.field_71075_bZ.field_75098_d) {
                if (PlayerData.get((EntityPlayer)player).game.getMoney() < (long)role.rentalMoney) {
                    return;
                }
                PlayerData.get((EntityPlayer)player).game.addMoney(role.rentalMoney * -1);
            }
        } else {
            ItemStack currency = role.rentalItems.func_70301_a(pos);
            if (currency.func_190926_b()) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
                map.put(currency, currency.func_190916_E());
                if (!Util.instance.canRemoveItems(role.rentalItems.items, map, false, false)) {
                    return;
                }
                Util.instance.removeItem(player, currency, false, false);
            }
        }
        if (EventHooks.onNPCRole(npc, event = new RoleEvent.FollowerHireEvent((EntityPlayer)player, npc.wrappedNPC, days = role.rates.get(pos).intValue()))) {
            return;
        }
        if (event.days == 0) {
            return;
        }
        npc.say((EntityPlayer)player, new Line(NoppesStringUtils.formatText(role.dialogHire.replace("{days}", days + ""), new Object[]{player, npc})));
        role.setOwner((EntityPlayer)player);
        role.addDays(days);
    }

    public static void hireFollower(EntityPlayerMP player, EntityNPCInterface npc, int pos) {
        if (!(npc.advanced.roleInterface instanceof RoleFollower)) {
            return;
        }
        Container con = player.field_71070_bA;
        if (!(con instanceof ContainerNPCFollowerHire)) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.advanced.roleInterface;
        NoppesUtilPlayer.followerBuy(role, pos, player, npc);
    }

    public static void openBankGui(BankData bd, EntityPlayerMP player, EntityNPCInterface npc, int ceilId) {
        bd.openBankGui((EntityPlayer)player, npc, ceilId);
        if (CustomNpcs.Server != null) {
            EntityPlayerMP pl;
            if (bd.bank.isPublic) {
                for (EntityPlayerMP pl2 : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                    if (pl2.equals((Object)player) || !(pl2.field_71070_bA instanceof ContainerNPCBank) || ((ContainerNPCBank)pl2.field_71070_bA).bank.id != bd.bank.id || ((ContainerNPCBank)pl2.field_71070_bA).ceil != ceilId) continue;
                    if (!bd.bank.access.isEmpty() && !bd.bank.access.contains(pl2.func_70005_c_())) {
                        pl2.func_71128_l();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.bank.changed", new Object[0]));
                        continue;
                    }
                    bd.openBankGui((EntityPlayer)pl2, npc, ceilId);
                }
            } else if (!player.func_110124_au().equals(bd.getUUID()) && !(pl = CustomNpcs.Server.func_184103_al().func_177451_a(bd.getUUID())).equals((Object)player) && pl.field_71070_bA instanceof ContainerNPCBank && ((ContainerNPCBank)pl.field_71070_bA).bank.id == bd.bank.id && ((ContainerNPCBank)pl.field_71070_bA).ceil == ceilId) {
                bd.openBankGui((EntityPlayer)pl, npc, ceilId);
            }
        }
    }

    public static void questCompletion(EntityPlayerMP player, int questId) {
        NoppesUtilPlayer.questCompletion(player, questId, ItemStack.field_190927_a);
    }

    public static void questCompletion(EntityPlayerMP player, int questId, ItemStack stack) {
        Quest nextQuest;
        PlayerData data = PlayerData.get((EntityPlayer)player);
        PlayerQuestData playerdata = data.questData;
        QuestData activeData = playerdata.activeQuests.get(questId);
        if (activeData == null) {
            return;
        }
        Quest quest = activeData.quest;
        if (!quest.questInterface.isCompleted((EntityPlayer)player) && !activeData.isCompleted) {
            return;
        }
        QuestEvent.QuestTurnedInEvent event = new QuestEvent.QuestTurnedInEvent(data.scriptData.getPlayer(), quest);
        event.expReward = quest.rewardExp;
        event.moneyReward = quest.rewardMoney;
        ArrayList<IItemStack> rewardList = new ArrayList<IItemStack>();
        for (ItemStack item : quest.rewardItems.items) {
            if (item == null || item.func_190926_b()) continue;
            rewardList.add(Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item));
        }
        if (!rewardList.isEmpty()) {
            switch (quest.rewardType) {
                case RANDOM_ONE: {
                    event.itemRewards = new IItemStack[]{(IItemStack)rewardList.get(player.func_70681_au().nextInt(rewardList.size()))};
                    break;
                }
                case ONE_SELECT: {
                    if (stack == null) {
                        stack = ItemStack.field_190927_a;
                    }
                    event.itemRewards = new IItemStack[]{Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack)};
                    break;
                }
                default: {
                    event.itemRewards = new IItemStack[rewardList.size()];
                    int i = 0;
                    Iterator iterator = rewardList.iterator();
                    while (iterator.hasNext()) {
                        IItemStack item;
                        event.itemRewards[i] = item = (IItemStack)iterator.next();
                        ++i;
                    }
                    break block0;
                }
            }
        }
        event.factionOptions = quest.factionOptions;
        EventHooks.onQuestTurnedIn(data.scriptData, event);
        quest.questInterface.handleComplete((EntityPlayer)player);
        if (event.expReward > 0) {
            NoppesUtilServer.playSound((EntityLivingBase)player, SoundEvents.field_187604_bf, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            player.func_71023_q(event.expReward);
        }
        if (event.moneyReward > 0) {
            data.game.addMoney(event.moneyReward);
        }
        event.factionOptions.addPoints((EntityPlayer)player);
        if (event.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), player.func_70005_c_(), event.mail);
        }
        if (!event.command.isEmpty()) {
            IItemStack[] com_player = EntityNPCInterface.CommandPlayer;
            com_player.func_70029_a(player.field_70170_p);
            com_player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            NoppesUtilServer.runCommand((ICommandSender)com_player, "QuestCompletion", event.command, (EntityPlayer)player);
        }
        for (IItemStack stackRew : event.itemRewards) {
            NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, stackRew.getMCItemStack());
        }
        PlayerQuestController.setQuestFinished(quest, (EntityPlayer)player);
        Quest quest2 = nextQuest = QuestController.instance == null ? null : QuestController.instance.quests.get(event.nextQuestId);
        if (nextQuest != null) {
            PlayerQuestController.addActiveQuest(nextQuest, (EntityPlayer)player, false);
        }
        Server.sendData(player, EnumPacketClient.MESSAGE, "quest.finished", quest.getTitle(), 2);
        Server.sendData(player, EnumPacketClient.CHAT, "quest.finished", ": ", quest.getTitle());
    }

    public static void sendData(EnumPlayerPacket enu, Object ... obs) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        try {
            if (!Server.fillBuffer((ByteBuf)buffer, enu, obs)) {
                return;
            }
            CustomNpcs.ChannelPlayer.sendToServer(new FMLProxyPacket(buffer, "CNPCsPlayer"));
        }
        catch (Exception e) {
            LogWriter.error("Error send data:", e);
        }
    }

    public static void teleportPlayer(EntityPlayerMP player, double x, double y, double z, int dimension, float yaw, float pitch) {
        if (player.field_71093_bK != dimension) {
            MinecraftServer server = player.func_184102_h();
            if (server == null) {
                return;
            }
            WorldServer world = server.func_71218_a(dimension);
            if (world == null) {
                return;
            }
            ForgeHooks.onTravelToDimension((Entity)player, (int)dimension);
            player.func_70012_b(x, y, z, yaw, pitch);
            server.func_184103_al().transferPlayerToDimension(player, dimension, (Teleporter)new CustomTeleporter(world));
            player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            if (!world.field_73010_i.contains(player)) {
                world.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }

    public static void sendDataCheckDelay(EnumPlayerPacket enu, Object key, long time, Object ... obs) {
        if (delaySendMap.containsKey(key) && delaySendMap.get(key) > System.currentTimeMillis()) {
            return;
        }
        ArrayList<Object> del = new ArrayList<Object>();
        for (Object k : delaySendMap.keySet()) {
            if (delaySendMap.get(k) > System.currentTimeMillis()) continue;
            del.add(k);
        }
        for (Object k : del) {
            delaySendMap.remove(k);
        }
        delaySendMap.put(key, time + System.currentTimeMillis());
        NoppesUtilPlayer.sendData(enu, obs);
    }
}

